local mp = require 'mp'
local assdraw = require 'mp.assdraw'

local showing = false
local paused = false
local dot_count = 0
local direction = 1
local max_dots = 3
local timer = nil

local base_text_playing = "Audio playing now"
local color = "&HE8731A&"

local blink_state = 0

local function show_text()
    if not showing then return end

    local w, h = mp.get_osd_size()
    local fs = math.max(20, math.floor(h * 0.07))
    local ass = assdraw.ass_new()

    if paused then
        local big_fs = fs * 1
        local alpha_tag = (blink_state == 0) and "\\alpha&H00&" or "\\alpha&HFF&"
        local pause_symbol = "█ █"

        ass:append(string.format(
            "{\\an5\\fs%d\\fnLiberation Sans\\1c%s\\i1%s}%s{\\i0}",
            big_fs, color, alpha_tag, pause_symbol
        ))

        blink_state = 1 - blink_state

    else
        local dots = string.rep(".", dot_count)
        ass:append(string.format(
            "{\\an5\\fs%d\\fnLiberation Sans\\1c%s\\i1}%s%s{\\i0}",
            fs, color, base_text_playing, dots
        ))

        dot_count = dot_count + direction
        if dot_count >= max_dots then
            direction = -1
            dot_count = max_dots
        elseif dot_count <= 0 then
            direction = 1
            dot_count = 0
        end
    end

    mp.set_osd_ass(w, h, ass.text)
end

local function start_timer()
    if timer then
        timer:kill()
        timer = nil
    end
    dot_count = 0
    direction = 1
    blink_state = 0
    timer = mp.add_periodic_timer(1.0, show_text)
    show_text()
end

mp.observe_property("pause", "bool", function(_, value)
    if showing then
        paused = value
        dot_count = 0
        direction = 1
        blink_state = 0
        show_text()
    end
end)

mp.register_event("file-loaded", function()
    local vid = mp.get_property_number("vid", 0)
    local aid = mp.get_property_number("aid", 0)

    if aid > 0 and vid == 0 then
        showing = true
        paused = mp.get_property_native("pause", false)
        start_timer()
    else
        if showing then
            showing = false
            if timer then
                timer:kill()
                timer = nil
            end
            mp.set_osd_ass(0, 0, "")
        end
    end
end)

mp.register_event("end-file", function()
    if showing then
        showing = false
        if timer then
            timer:kill()
            timer = nil
        end
        mp.set_osd_ass(0, 0, "")
    end
end)
